getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(tensorA)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)

load("s3-ini-setting.RData")
load("s3.pre.to.list.RData")

## Model: f(x) = B*U*g(x); B: 3*2, U: 3*3, x:2*2
dim.b = c(3,3,3); dim.u1 = c(4,3); dim.u2 = c(5,3); dim.x = c(2,3)
dim.f = c(4,5,2); t1 = dim.f[1]; t2 = dim.f[2]; t3 = dim.f[3]; 
dim.h = prod(dim.f); dim.mode = length(dim.f)
d = 3; lower.x = rep(0,d); upper.x = rep(1,d)
dim.mode.ml = dim.mode+1; dim.f.ml = c(dim.f,d)

B <- e3.ini.set$B 
U_mat <- e3.ini.set$U_mat 
V <- e3.ini.set$V

true.model <- function(x){
  X1 = sin(5*x); X2 = cos(x)
  X = matrix(cbind(X1,X2),dim.x)
  return(array(ttm(V, X, m = 3)@data,dim.f))
}
h <- function(x) sum(true.model(x))

x.star = directL(function(x0) -h(x0),lower.x,upper.x,control=list(xtol_rel=1e-8, maxeval=1000))$par
x.star = t(as.matrix(x.star))
t.star = true.model(x.star); h.star = h(x.star)


################################################################################
#### GP ########################################################################
################################################################################
################################################################################
## Our proposed method: MLGP
## Kernel
phi.x <- function(x) kronecker(diag(dim.h),x)
u.k <- function(t,ome) matrix(ome,t,t)

vec.lab = list()
for(om.lab in 1:dim.mode.ml){
  vec.lab[[om.lab]] = dim.f.ml[om.lab]^2
}
vec.lab[[dim.mode.ml+1]] = vec.lab[[dim.mode.ml+2]] = 1
group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.ml = length(group.lab)

lower.th = c(unlist(Map(rep, c(rep(1e-3,dim.mode.ml),1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(rep(1,dim.mode.ml),10,1e-2), unlist(vec.lab))))

ker.ml <- function(the){
  the0 = split(the, group.lab)
  sig = list()
  for(i in 1:dim.mode.ml){
    sig[[i]] = u.k(dim.f.ml[i],the0[[i]])
  }
  return(sig)
}
# ker.ml(c(runif(dim.hyper.ml)))

likeli.ml <- function(x,y,n,the){
  the0 = split(the, group.lab)
  ome = list()
  for(i in 1:dim.mode.ml){ome[[i]] = the0[[i]]}
  sig2 = the0[[dim.mode.ml+1]]; tau2 = the0[[dim.mode.ml+2]]
  
  sig = ker.ml(the); U = Reduce(kronecker,sig)
  Ut = phi.x(x)%*%U; sv <- svd(Ut)$d
  ld = sum(log(c(sv^2, rep(0, n*dim.h-length(sv)))+tau2))
  
  k.y = t(Ut)%*%Ut + tau2*diag(ncol(Ut)); sol.k.y = solve(k.y)
  
  log.likeli = 1/tau2*t(c(y))%*%c(y)-1/tau2*t(c(y))%*%Ut%*%sol.k.y%*%t(Ut)%*%c(y)+ 
    ld+Reduce(sum,sapply(sig, function(x) x^2))
  
  return(list(like=log.likeli, the0=the0))
}
# likeli.ml(x,y,n,runif(dim.hyper.ml))

EIJ <- function(i,j,l){
  E0 = matrix(0,dim.f.ml[l],dim.f.ml[l]); E0[i,j] = 1
  return(E0)
}

der.l <- function(x,y,n,the){
  the0 = split(the, group.lab)
  
  ome = list()
  for(i in 1:dim.mode.ml){ome[[i]] = the0[[i]]}
  sig2 = the0[[dim.mode.ml+1]]; tau2 = the0[[dim.mode.ml+2]]
  
  sig = list()
  for(i in 1:dim.mode.ml){
    sig[[i]] = u.k(dim.f.ml[i],the0[[i]])
  }
  
  u.brave = phi.x(x)%*%Reduce(kronecker,sig)
  k.ini = u.brave%*%t(u.brave)
  k.y = sig2*k.ini+tau2*diag(n*dim.h)
  sol.k.y = solve(k.y)
  
  al.k = sol.k.y%*%c(y)
  der.l.sig2 = tr(sol.k.y%*%k.ini)-t(al.k)%*%k.ini%*%al.k
  der.l.tau2 = tr(sol.k.y)-t(al.k)%*%al.k
  
  al.k1 = t(phi.x(x))%*%al.k
  der.l.phi = list()
  for(l in 1:dim.mode.ml){
    der.l.phi[[l]] = matrix(0, dim.f.ml[l], dim.f.ml[l])
    
    der.l.phi.ij <- function(i,j) EIJ(i,j,l)%*%t(sig[[l]])+sig[[l]]%*%EIJ(j,i,l)
    it1 <- function(der.p){
      list1 = if (l > 1) sig[1:(l-1)] else 1
      list2 = if (l < dim.mode.ml) sig[(l+1):dim.mode.ml] else 1
      kro.list = list(Reduce(kronecker,list1),der.p,Reduce(kronecker,list2))
      return(Reduce(kronecker,kro.list))
    } 
    it2 <- function(der.p) tr(t(phi.x(x))%*%sol.k.y%*%phi.x(x)%*%it1(der.p))-
      t(al.k1)%*%it1(der.p)%*%al.k1
    
    der.l.phi.1 = sapply(c(1:dim.f.ml[l]), function(i) {
      sapply(c(1:dim.f.ml[l]), function(j) it2(der.l.phi.ij(i, j)))
    })
    
    for (i in 1:dim.f.ml[l]) {
      der.l.phi[[l]][i, 1:dim.f.ml[l]] <- der.l.phi.1[[i]]
    }
  }
  
  result = list(der.l.phi=der.l.phi, der.l.sig2=der.l.sig2, der.l.tau2=der.l.tau2)
  return(result)
}
# unlist(der.l(x,y,n,runif(dim.hyper.ml)))


mlgp.hat <- function(x.new,x,y,n,n.test,hy){
  x.new = matrix(x.new,n.test,d)
  sig2 = hy[[dim.mode.ml+1]]; tau2 = hy[[dim.mode.ml+2]]
  
  sig = ker.ml(unlist(hy)); U = Reduce(kronecker,sig)
  Ut = phi.x(x)%*%U
  
  k.ini = Ut%*%t(Ut)
  k.y = sig2*k.ini + tau2*diag(nrow(k.ini))
  
  k.test = sig2*phi.x(x.new)%*%U%*%t(Ut)
  k.test0 = sig2*phi.x(x.new)%*%U%*%t(phi.x(x.new)%*%U)
  
  k.oth = k.test%*%solve(k.y)
  
  f.hat = k.oth%*%c(y)
  var.hat = k.test0-k.oth%*%t(k.test)
  
  result = list(mean = f.hat, cov = var.hat)
  return(result)
}
# mlgp.hat(x.star,x,y,n,1,split(runif(dim.hyper.ml), group.lab))



################################################################################
## MLGP-UCB
n = 5*d; m  = 10*d; lambda=0.1; J.for=10

like.re.ml = hyper.ml = lapply(1:J.for, function(x) list())
x0.ml = y0.ml = ind0.ml = list(); fhat = lapply(1:J.for, function(x) list())
mlgp.bo = h.ml = list()
mse.x.ml = mae.y.ml = list()
regret.ml = ins.regret.ml = cum.regret.ml = list()

for(j.for.ml in 1:J.for){
  x = e3.ini.set$x 
  f = e3.ini.set$f 
  y0 = e3.ini.set$y.for[[j.for.ml]]
  y = aperm(y0, c(dim.mode.ml,c(1:dim.mode)))
  
  ## Setting
  ######################################## BO ####################################
  hyper.ml.old = directL(function(the) likeli.ml(x,y,n,the)$like,lower.th,upper.th,control=list(maxeval=1000))$par
  opts <- list("algorithm"="NLOPT_LD_LBFGS", "xtol_rel"=1.0e-5)
  hyper.ml.new = nloptr(x0=hyper.ml.old,
                        eval_f = function(the) likeli.ml(x,y,n,the)$like,
                        eval_grad_f=function(the) unlist(der.l(x,y,n,the)),
                        opts=opts,lb = lower.th, ub = upper.th)$solution
  
  like.re.ml[[j.for.ml]][[1]] = likeli.ml(x,y,n,hyper.ml.new)
  hyper.ml[[j.for.ml]][[1]] = like.re.ml[[j.for.ml]][[1]]$the0
  
  x0.ml[[j.for.ml]] = x; y0.ml[[j.for.ml]] = y; n.ml = n
  x.new.ml = t(as.matrix(x[which.max(apply(x,1,h)),]))
  y.new.ml = f[which.max(apply(x,1,h)),,,]
  
  hyper.ml.ucb = unlist(hyper.ml[[j.for.ml]][[1]]); delta.ml = 0.05
  fhat[[j.for.ml]][[1]] = mlgp.hat(x.new.ml,x,y0.ml[[j.for.ml]],n.ml,1,hyper.ml[[j.for.ml]][[1]])
  
  for(i.ml in 1:m){
    x.new.ml = t(t(randomLHS(1,d))*(upper.x-lower.x) + lower.x)
    
    fhat[[j.for.ml]][[i.ml+1]] = mlgp.hat(x.new.ml,x0.ml[[j.for.ml]],y0.ml[[j.for.ml]],n.ml,n.test=1,hyper.ml[[j.for.ml]][[i.ml]])
    y.new.ml = true.model(x.new.ml)+array(rnorm(dim.h, mean=0, sd=lambda), dim=c(dim.f))

    x0.ml[[j.for.ml]] = rbind(x0.ml[[j.for.ml]], x.new.ml)
    y0.ml[[j.for.ml]] = abind(y0.ml[[j.for.ml]], y.new.ml, along = 1)
    n.ml = n+i.ml
    
    if(i.ml %% 5 == 0){
      hyper.ml.ucb = nloptr(x0=unlist(hyper.ml[[j.for.ml]][[i.ml]]),
                            eval_f = function(the) likeli.ml(x0.ml[[j.for.ml]],y0.ml[[j.for.ml]],n.ml,the)$like,
                            eval_grad_f=function(the) unlist(der.l(x0.ml[[j.for.ml]],y0.ml[[j.for.ml]],n.ml,the)),
                            opts=opts,lb = lower.th, ub = upper.th)$solution
    }else{
      hyper.ml.ucb = hyper.ml.ucb
    }
    
    like.re.ml[[j.for.ml]][[i.ml+1]] = likeli.ml(x0.ml[[j.for.ml]],y0.ml[[j.for.ml]],n.ml,hyper.ml.ucb)
    hyper.ml[[j.for.ml]][[i.ml+1]] = like.re.ml[[j.for.ml]][[i.ml+1]]$the0
    print(i.ml)
  }
  
  mlgp.bo[[j.for.ml]] = Map(function(a) true.model(a),split(x0.ml[[j.for.ml]],row(x0.ml[[j.for.ml]])))
  h.ml[[j.for.ml]] = apply(x0.ml[[j.for.ml]],1,h)
  
  mse.x.ml[[j.for.ml]] = apply(x0.ml[[j.for.ml]],1,function(x) mean((x-x.star)^2))
  mae.y.ml[[j.for.ml]] = unlist(lapply(fhat[[j.for.ml]],function(a) mean(abs((a$mean-c(t.star))/c(t.star)))))
  regret.ml[[j.for.ml]] = h.star-unlist(h.ml[[j.for.ml]])
  
  ins.regret.ml[[j.for.ml]] = h.star-cummax(h.ml[[j.for.ml]])
  cum.regret.ml[[j.for.ml]] = cumsum(ins.regret.ml[[j.for.ml]])
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(h.star,(n.ml-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(h.ml[[j.for.ml]])[n],h.star))
  lines(cummax(h.ml[[j.for.ml]])[n:n.ml],type="b",lwd=3,lty=2,pch=2,col=2)
  
  plot(log(cummin(regret.ml[[j.for.ml]])),type="b",lwd=3,lty=1,pch=1,col=1)
  
  print(j.for.ml)
}



fml.rs.list = list(like.re.ml=like.re.ml, hyper.ml=hyper.ml, 
                    x0.ml=x0.ml, y0.ml=y0.ml, mlgp.bo=mlgp.bo, h.ml=h.ml, 
                    mse.x.ml=mse.x.ml, mae.y.ml=mae.y.ml, regret.ml=regret.ml, 
                    ins.regret.ml=ins.regret.ml, cum.regret.ml=cum.regret.ml)
save(fml.ucb.list, file="s3.fml.rs.RData")



















